<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


/**
 * Set the Login Form redirect URL
 *
 * @param $user_login
 * @param $user
 *
 * @return void
 */
function handle_get_redirect_url( $user_login, $user ) {

    // skip if not AJAX Validation process
    if ( !isset( $_POST['ajax_action'] ) || $_POST['ajax_action'] !== 'form_validation' )
        return;

    $redirect_priority = !empty( $_POST['wppb_redirect_priority'] ) ? sanitize_text_field( $_POST['wppb_redirect_priority'] ) : 'normal';
    $redirect_url = isset( $_POST['redirect_to'] ) ? sanitize_text_field( $_POST['redirect_to'] ) : null;
    $redirect_value = wppb_get_redirect_url ($redirect_priority, 'after_login', $redirect_url, $user );

    // set the redirect URL for AJAX Validation process
    wp_send_json_success( array( 'after_login_redirect_url' => $redirect_value ) );
}
add_action('wp_login', 'handle_get_redirect_url', 10, 2);